*** rt-U.do
*** v1.1
clear all
set more off
set type double
set matsize 1000

*** create rt vintages
insheet using UNEMPLOY_2_Vintages_Starting_1961_02_09.txt, clear
gen int mdate = mofd(date(observation_date,"YMD"))
tsset mdate, m
order mdate
drop observation_date

** these releases took place the day preceding the "correct" month
rename unemploy_19610531 unemploy_19610601
rename unemploy_19610829 unemploy_19610901
rename unemploy_19620131 unemploy_19620201
rename unemploy_19620531 unemploy_19620601
rename unemploy_19621031 unemploy_19621101
rename unemploy_19630131 unemploy_19630201
rename unemploy_19631031 unemploy_19631101

* there is no vintage for April 2000; create from following month
gen unemploy_20000405 = unemploy_20000505
qui replace unemploy_20000405 = . if mdate==tm(2000m4)

** drop the day from the release date
unab rellist: unemploy_*
local rdatelist: subinstr local rellist "unemploy_" "", all
macro drop _rellist
foreach rdate of local rdatelist {
    local yr = string(int(`rdate'/10000),"%04.0f")
    local mon = string(int(`rdate'/100)-int(`rdate'/10000)*100,"%02.0f")
*    local rmdate = `yr'`mon'
    local rmdate = ym(`yr',`mon')
    rename unemploy_`rdate' U_`rmdate'
}

compress
aorder
order mdate
save rt-U.dta, replace
